/////////////////////////////////////////////////////////////////////
// 組込みの簡易自動コマンド（draw()をループしないのでGUIは反応しない）
/////////////////////////////////////////////////////////////////////
// 説明は末尾に記述してある．

void autoCommand1() {
}

void autoCommand2() {
}

void autoCommand3() {
}

void autoCommand4() {
}

void autoCommand5() {
}

void autoCommand6() {
}

void autoCommand7() {
}

void autoCommand8() {
}

// サンプル１
void autoCommand9() {
  rc.joint_angle_zero().doing().wait(1000);  // 動作コマンドの後には必ずdoingを付ける．waitの後では意味がない．
  rc.robot_fwd().joint_cw_15deg().doing();   // 前進開始と同時に関節を15度回転開始（同時に実行可能だという以外に意味はない）
  rc.wait(1000);                             // waitは単独で使用しても構わない
  rc.all_motor_stop().doing();
}

// サンプル２
void autoCommand10() {
  rc.joint_angle_zero().doing().wait(1000);  // 関節角度回転完了を確認できないため
  rc.robot_fwd().doing().wait(5000);         // 前進開始，５秒待つ
  rc.robot_bwd().doing().wait(5000);         // 後進開始，５秒待つ
  rc.all_motor_stop().doing();                // 全モーター停止（不要だが，念のために）
}

// RobotControlクラスの中で，関数の型としてRobotControlが指定されているものは以下で使用可能（doing(), wait()も含む）
// モーターを制御するコマンドの後にはdoing()が必要．doing()を実行すると，command_flagが送信される．
// wait()で待機（命令の持続時間と考えることもできる）．単位は[ms]．精度はあまり期待しない方が良い（そこまで悪くはない）．
// rc.robot_fwd(); のように単発で書いても構わないし，rc.robot_fwd().joint_cw_15deg();のように連ねて記述しても構わない．左から順に実行される．
// ただし，モーターを制御する関数群はフラグを書き換えているだけなので，rc.doing()を実行しなくては意味がない．
// rc.robot_fwd().doing().wait(5000); のような書き方が一般的である．ロボットを前進するフラグをセットして，それを送信して，５秒待つ．
// これを，rc.robot_fwd(); rc.doing(); rc.wait(5000); のように分けて記述しても動作は同一である．
// なお，rc.robot_fwd().wait(5000).doing();の順では正しく動作しない（５秒待機した後にロボットが前進を始める）．
// もしその意図で記述するならば，rc.wait(5000).robot_fwd().doing(); の順の記述が好ましい．
